<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Наши мастера';
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="beauty-masters">
        <div class="masters-header">
            <h1><?= Html::encode($this->title) ?></h1>
            <div class="divider">
                <span class="divider-icon">💇‍♀️</span>
            </div>
            <p class="header-description">Профессионалы своего дела, которые подарят вам красоту и уверенность</p>
        </div>

        <div class="masters-grid">
            <?php foreach ($masters as $master): ?>
                <?php $masterInfo = isset($masterInfos[$master->id]) ? $masterInfos[$master->id] : null; ?>
                <div class="master-card">
                    <div class="master-card-inner">
                        <div class="master-avatar">
                            <?php
                            $initials = strtoupper(substr($master->name, 0, 1) . substr($master->surname, 0, 1));
                            $colors = ['#b3456b', '#d46b91', '#a65a72', '#c47894', '#e396b2'];
                            $colorIndex = ($master->id - 1) % count($colors);
                            ?>
                            <div class="avatar-circle" style="background: <?= $colors[$colorIndex] ?>;">
                                <span class="avatar-text"><?= $initials ?></span>
                            </div>

                            <?php if ($masterInfo && $masterInfo->is_active): ?>
                                <div class="status-badge active" title="Принимает клиентов">
                                    <span class="status-dot"></span>
                                </div>
                            <?php else: ?>
                                <div class="status-badge inactive" title="Временно не принимает">
                                    <span class="status-dot"></span>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="master-info">
                            <h3 class="master-name">
                                <?= Html::a(
                                    Html::encode($master->surname . ' ' . $master->name),
                                    ['master/view', 'id' => $master->id],
                                    ['class' => 'master-link']
                                ) ?>
                            </h3>

                            <?php if ($masterInfo && $masterInfo->specialization): ?>
                                <div class="master-specialization">
                                    <?= Html::encode($masterInfo->specialization) ?>
                                </div>
                            <?php endif; ?>

                            <div class="master-details">
                                <?php if ($masterInfo && $masterInfo->experience_years): ?>
                                    <div class="master-experience">
                                        <span class="detail-icon">⭐</span>
                                        <span>Опыт: <?= $masterInfo->experience_years ?> лет</span>
                                    </div>
                                <?php endif; ?>

                                <?php if ($masterInfo && $masterInfo->certificate_expiry): ?>
                                    <div class="master-certificate">
                                        <span class="detail-icon">📜</span>
                                        <span>Сертификат до: <?= Yii::$app->formatter->asDate($masterInfo->certificate_expiry) ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <?php if ($masterInfo && $masterInfo->bio): ?>
                                <div class="master-bio">
                                    <?= Html::encode(mb_substr($masterInfo->bio, 0, 100)) ?>
                                    <?php if (mb_strlen($masterInfo->bio) > 100): ?>...<?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="master-actions">
                            <?= Html::a('Подробнее', ['master/view', 'id' => $master->id], [
                                'class' => 'btn master-btn primary'
                            ]) ?>
                            <?= Html::a('Записаться', ['appointment/create'], [
                                'class' => 'btn master-btn secondary',
                                'data' => [
                                    'method' => 'post',
                                    'params' => ['master_id' => $master->id]
                                ]
                            ]) ?>
                        </div>

                        <?php if ($masterInfo && $masterInfo->is_active): ?>
                            <div class="master-status active-status">
                                <span class="status-text">✅ Принимает клиентов</span>
                            </div>
                        <?php else: ?>
                            <div class="master-status inactive-status">
                                <span class="status-text">⏳ Временно не принимает</span>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

<?php
$css = <<< CSS
    .beauty-masters {
        max-width: 1200px;
        margin: 0 auto;
        padding: 40px 20px;
        font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
    }

    /* Заголовок страницы */
    .masters-header {
        text-align: center;
        margin-bottom: 50px;
    }

    .masters-header h1 {
        color: #b3456b;
        font-size: 2.8em;
        font-weight: 600;
        margin-bottom: 15px;
        text-shadow: 2px 2px 4px rgba(179, 69, 107, 0.1);
    }

    .divider {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 15px;
        margin: 20px 0;
    }

    .divider::before,
    .divider::after {
        content: '';
        width: 80px;
        height: 2px;
        background: linear-gradient(90deg, transparent, #b3456b, #d46b91, #b3456b, transparent);
    }

    .divider-icon {
        font-size: 2em;
        color: #b3456b;
    }

    .header-description {
        color: #a65a72;
        font-size: 1.2em;
        max-width: 600px;
        margin: 20px auto 0;
        line-height: 1.6;
    }

    /* Сетка мастеров */
    .masters-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
        gap: 30px;
    }

    /* Карточка мастера */
    .master-card {
        background: white;
        border-radius: 25px;
        box-shadow: 0 10px 30px rgba(179, 69, 107, 0.1);
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }

    .master-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 40px rgba(179, 69, 107, 0.2);
    }

    .master-card-inner {
        padding: 30px 25px;
        position: relative;
    }

    .master-card-inner::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 5px;
        background: linear-gradient(90deg, #b3456b, #d46b91);
    }

    /* Аватар */
    .master-avatar {
        position: relative;
        width: 140px;
        height: 140px;
        margin: 0 auto 20px;
    }

    .avatar-circle {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        animation: float 3s ease-in-out infinite;
    }

    .avatar-text {
        font-size: 48px;
        font-weight: 600;
        color: white;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
    }

    @keyframes float {
        0%, 100% {
            transform: translateY(0);
        }
        50% {
            transform: translateY(-5px);
        }
    }

    /* Статус */
    .status-badge {
        position: absolute;
        bottom: 5px;
        right: 5px;
        width: 25px;
        height: 25px;
        border-radius: 50%;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    }

    .status-dot {
        width: 15px;
        height: 15px;
        border-radius: 50%;
    }

    .status-badge.active .status-dot {
        background: #4caf50;
        box-shadow: 0 0 10px #4caf50;
    }

    .status-badge.inactive .status-dot {
        background: #ff9800;
        box-shadow: 0 0 10px #ff9800;
    }

    /* Информация о мастере */
    .master-info {
        text-align: center;
        margin-bottom: 20px;
    }

    .master-name {
        margin: 0 0 10px;
        font-size: 1.5em;
    }

    .master-link {
        color: #b3456b;
        text-decoration: none;
        transition: color 0.3s ease;
        position: relative;
        display: inline-block;
    }

    .master-link::after {
        content: '';
        position: absolute;
        bottom: -2px;
        left: 0;
        width: 0;
        height: 2px;
        background: #b3456b;
        transition: width 0.3s ease;
    }

    .master-link:hover {
        color: #a65a72;
    }

    .master-link:hover::after {
        width: 100%;
    }

    .master-specialization {
        color: #a65a72;
        font-size: 1.1em;
        margin-bottom: 15px;
        padding: 5px 15px;
        background: #fdf2f8;
        border-radius: 20px;
        display: inline-block;
    }

    .master-details {
        margin: 15px 0;
        text-align: left;
    }

    .master-experience,
    .master-certificate {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-bottom: 8px;
        color: #666;
        font-size: 0.95em;
    }

    .detail-icon {
        font-size: 1.2em;
        min-width: 25px;
    }

    .master-bio {
        color: #888;
        font-size: 0.95em;
        line-height: 1.6;
        margin: 15px 0;
        padding: 15px;
        background: #fdf2f8;
        border-radius: 15px;
        font-style: italic;
    }

    /* Кнопки */
    .master-actions {
        display: flex;
        gap: 10px;
        margin-bottom: 15px;
    }

    .master-btn {
        flex: 1;
        padding: 10px 15px;
        border: none;
        border-radius: 25px;
        font-size: 0.95em;
        font-weight: 600;
        text-decoration: none;
        text-align: center;
        transition: all 0.3s ease;
        cursor: pointer;
    }

    .master-btn.primary {
        background: #b3456b;
        color: white;
    }

    .master-btn.primary:hover {
        background: #a65a72;
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(179, 69, 107, 0.4);
    }

    .master-btn.secondary {
        background: transparent;
        color: #b3456b;
        border: 2px solid #b3456b;
    }

    .master-btn.secondary:hover {
        background: #b3456b;
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(179, 69, 107, 0.4);
    }

    /* Статус внизу карточки */
    .master-status {
        text-align: center;
        margin-top: 15px;
        padding-top: 15px;
        border-top: 2px dashed #f0d9e3;
    }

    .active-status .status-text {
        color: #4caf50;
        font-weight: 600;
    }

    .inactive-status .status-text {
        color: #ff9800;
        font-weight: 600;
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .masters-header h1 {
            font-size: 2.2em;
        }

        .masters-grid {
            grid-template-columns: 1fr;
        }

        .master-card {
            max-width: 400px;
            margin: 0 auto;
        }
    }

    @media (max-width: 480px) {
        .master-actions {
            flex-direction: column;
        }

        .master-avatar {
            width: 120px;
            height: 120px;
        }

        .avatar-text {
            font-size: 40px;
        }
    }

    /* Анимация появления карточек */
    .master-card {
        animation: cardAppear 0.5s ease forwards;
        opacity: 0;
    }

    @keyframes cardAppear {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .master-card:nth-child(1) { animation-delay: 0.1s; }
    .master-card:nth-child(2) { animation-delay: 0.2s; }
    .master-card:nth-child(3) { animation-delay: 0.3s; }
    .master-card:nth-child(4) { animation-delay: 0.4s; }
    .master-card:nth-child(5) { animation-delay: 0.5s; }
    .master-card:nth-child(6) { animation-delay: 0.6s; }
CSS;

$this->registerCss($css);
?>