<?php

/** @var yii\web\View $this */
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Салон красоты "BeautyCute"';
?>

    <div class="beauty-home">

        <!-- Hero секция с быстрыми ссылками -->
        <section class="hero-section">
            <div class="hero-overlay">
                <div class="container">
                    <div class="hero-content">
                        <h1 class="hero-title">BeautyCute</h1>
                        <p class="hero-subtitle">Салон красоты, где начинается ваше преображение</p>
                        <div class="hero-buttons">
                            <?= Html::a('Услуги и цены', ['/catalog/index'], ['class' => 'btn hero-btn primary']) ?>
                            <?= Html::a('Записаться онлайн', ['/appointment/create'], ['class' => 'btn hero-btn secondary']) ?>
                            <?= Html::a('Наши мастера', ['/site/masters'], ['class' => 'btn hero-btn outline']) ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Краткое описание салона -->
        <section class="about-section">
            <div class="container">
                <div class="section-header">
                    <h2>О салоне</h2>
                    <div class="divider">
                        <span class="divider-icon">💅</span>
                    </div>
                </div>
                <div class="about-content">
                    <div class="about-text">
                        <p>Добро пожаловать в <strong>BeautyCute</strong> – пространство красоты и гармонии в самом сердце города. Мы создали салон, где каждая женщина и каждый мужчина могут почувствовать себя особенными.</p>
                        <p>Наша философия – индивидуальный подход к каждому клиенту. Мы используем только профессиональную косметику премиум-класса и следим за новейшими тенденциями в индустрии красоты.</p>
                        <p>В нашем салоне работают дипломированные мастера с многолетним опытом, которые постоянно повышают свою квалификацию на международных семинарах и мастер-классах.</p>
                    </div>
                    <div class="about-stats">
                        <div class="stat-item">
                            <div class="stat-number">5+</div>
                            <div class="stat-label">лет безупречной работы</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number">5</div>
                            <div class="stat-label">профессиональных мастеров</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number">3000+</div>
                            <div class="stat-label">довольных клиентов</div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Слайдер с акциями и новостями -->
        <section class="promo-section">
            <div class="container">
                <div class="section-header">
                    <h2>Акции и новости</h2>
                    <div class="divider">
                        <span class="divider-icon">🎉</span>
                    </div>
                </div>
                <div class="promo-slider">
                    <div class="slider-container">
                        <div class="slider-track" id="promoSlider">
                            <div class="slide">
                                <div class="promo-card">
                                    <div class="promo-badge">-20%</div>
                                    <h3>Стрижка + укладка</h3>
                                    <p>При первом посещении скидка 20% на любую услугу</p>
                                    <span class="promo-valid">Действует до 31.03.2026</span>
                                </div>
                            </div>
                            <div class="slide">
                                <div class="promo-card">
                                    <div class="promo-badge">Подарок</div>
                                    <h3>Маникюр в подарок</h3>
                                    <p>При заказе комплексного ухода за лицом</p>
                                    <span class="promo-valid">Действует до 15.04.2026</span>
                                </div>
                            </div>
                            <div class="slide">
                                <div class="promo-card">
                                    <div class="promo-badge">-15%</div>
                                    <h3>День рождения</h3>
                                    <p>Скидка 15% в день рождения + 7 дней после</p>
                                    <span class="promo-valid">Постоянное предложение</span>
                                </div>
                            </div>
                            <div class="slide">
                                <div class="promo-card">
                                    <div class="promo-badge">Новинка</div>
                                    <h3>СПА-программа</h3>
                                    <p>Новая процедура для идеальной кожи лица</p>
                                    <span class="promo-valid">С 1 марта 2026</span>
                                </div>
                            </div>
                            <div class="slide">
                                <div class="promo-card">
                                    <div class="promo-badge">-25%</div>
                                    <h3>Семейный день</h3>
                                    <p>Скидка 25% для мамы и дочери</p>
                                    <span class="promo-valid">По воскресеньям</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button class="slider-btn prev" id="sliderPrev">❮</button>
                    <button class="slider-btn next" id="sliderNext">❯</button>
                </div>
                <div class="slider-dots" id="sliderDots"></div>
            </div>
        </section>

        <!-- Быстрые ссылки на услуги -->
        <section class="services-section">
            <div class="container">
                <div class="section-header">
                    <h2>Наши услуги</h2>
                    <div class="divider">
                        <span class="divider-icon">✂️</span>
                    </div>
                </div>
                <div class="services-grid">
                    <div class="service-card">
                        <div class="service-icon">💇</div>
                        <h3>Парикмахерские услуги</h3>
                        <p>Стрижки, укладки, окрашивание</p>
                        <?= Html::a('Подробнее', ['/catalog/index', 'category' => 1], ['class' => 'service-link']) ?>
                    </div>
                    <div class="service-card">
                        <div class="service-icon">💅</div>
                        <h3>Ногтевой сервис</h3>
                        <p>Маникюр, педикюр, наращивание</p>
                        <?= Html::a('Подробнее', ['/catalog/index', 'category' => 2], ['class' => 'service-link']) ?>
                    </div>
                    <div class="service-card">
                        <div class="service-icon">🧴</div>
                        <h3>Косметология</h3>
                        <p>Чистка лица, уход за кожей</p>
                        <?= Html::a('Подробнее', ['/catalog/index', 'category' => 3], ['class' => 'service-link']) ?>
                    </div>
                    <div class="service-card">
                        <div class="service-icon">💄</div>
                        <h3>Макияж</h3>
                        <p>Дневной, вечерний, свадебный</p>
                        <?= Html::a('Подробнее', ['/catalog/index', 'category' => 4], ['class' => 'service-link']) ?>
                    </div>
                    <div class="service-card">
                        <div class="service-icon">💆</div>
                        <h3>Массаж</h3>
                        <p>Лечебный, расслабляющий</p>
                        <?= Html::a('Подробнее', ['/catalog/index', 'category' => 5], ['class' => 'service-link']) ?>
                    </div>
                    <div class="service-card">
                        <div class="service-icon">✨</div>
                        <h3>Все услуги</h3>
                        <p>Полный каталог</p>
                        <?= Html::a('Смотреть все', ['/catalog/index'], ['class' => 'service-link']) ?>
                    </div>
                </div>
            </div>
        </section>

        <!-- История и миссия -->
        <section class="history-section">
            <div class="container">
                <div class="history-content">
                    <div class="history-text">
                        <h2>Наша история</h2>
                        <p>Салон красоты "BeautyCute" открыл свои двери в 2020 году. За это время мы прошли путь от небольшого кабинета до просторного салона с 15 мастерами.</p>
                        <p>Наша миссия – дарить красоту и уверенность каждому клиенту. Мы верим, что уход за собой – это не роскошь, а необходимость для современного человека.</p>
                        <blockquote>
                            "Красота начинается с момента, когда вы решаете быть собой"
                            <cite>— основатель салона</cite>
                        </blockquote>
                    </div>
                    <div class="history-image">
                        <img src="/images/salon-interior.jpg" alt="Интерьер салона" onerror="this.style.display='none'">
                        <div class="placeholder-image">✨ BeautyCute</div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Команда мастеров (кратко) -->
        <section class="team-section">
            <div class="container">
                <div class="section-header">
                    <h2>Наша команда</h2>
                    <div class="divider">
                        <span class="divider-icon">👥</span>
                    </div>
                </div>
                <div class="team-preview">
                    <p>В нашем салоне работают лучшие мастера с многолетним опытом</p>
                    <?= Html::a('Познакомиться с командой', ['/site/masters'], ['class' => 'btn team-btn']) ?>
                </div>
            </div>
        </section>

        <!-- Контакты и карта -->
        <section class="contacts-section">
            <div class="container">
                <div class="section-header">
                    <h2>Контакты</h2>
                    <div class="divider">
                        <span class="divider-icon">📞</span>
                    </div>
                </div>
                <div class="contacts-content">
                    <div class="contact-info">
                        <div class="contact-item">
                            <span class="contact-icon">📍</span>
                            <div>
                                <h4>Адрес</h4>
                                <p>г. Москва, ул. Московская, д. 67</p>
                            </div>
                        </div>
                        <div class="contact-item">
                            <span class="contact-icon">📞</span>
                            <div>
                                <h4>Телефон</h4>
                                <p><a href="tel:+74951234567">+7 (495) 123-45-67</a></p>
                            </div>
                        </div>
                        <div class="contact-item">
                            <span class="contact-icon">✉️</span>
                            <div>
                                <h4>Email</h4>
                                <p><a href="mailto:info@beautycute.ru">info@beautycute.ru</a></p>
                            </div>
                        </div>
                        <div class="contact-item">
                            <span class="contact-icon">🕒</span>
                            <div>
                                <h4>Режим работы</h4>
                                <p>Пн-Пт: 9:00 - 21:00<br>Сб-Вс: 10:00 - 20:00</p>
                            </div>
                        </div>
                    </div>
                    <div class="contact-map">
                        <div class="map-placeholder">
                            <iframe
                                    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2245.0!2d37.6!3d55.7!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zNTXCsDQyJzAwLjAiTiAzN8KwMzYnMDAuMCJF!5e0!3m2!1sru!2sru!4v1234567890"
                                    width="100%"
                                    height="300"
                                    style="border:0; border-radius: 15px;"
                                    allowfullscreen=""
                                    loading="lazy">
                            </iframe>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </div>

<?php
$css = <<< CSS
    .beauty-home {
        font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
        color: #4a4a4a;
        overflow-x: hidden;
    }

    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 20px;
    }

    /* Hero секция */
    .hero-section {
        background: url('/images/beauty-salon-bg.jpg') center/cover no-repeat;
        min-height: 600px;
        position: relative;
        color: white;
    }

    .hero-overlay {
        background: linear-gradient(135deg, rgba(179, 69, 107, 0.9), rgba(212, 107, 145, 0.8));
        min-height: 600px;
        display: flex;
        align-items: center;
    }

    .hero-content {
        text-align: center;
        max-width: 800px;
        margin: 0 auto;
        padding: 60px 20px;
    }

    .hero-title {
        font-size: 4em;
        font-weight: 700;
        margin-bottom: 20px;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
        animation: fadeInDown 1s ease;
    }

    .hero-subtitle {
        font-size: 1.5em;
        margin-bottom: 40px;
        opacity: 0.9;
        animation: fadeInUp 1s ease 0.3s both;
    }

    .hero-buttons {
        display: flex;
        gap: 20px;
        justify-content: center;
        flex-wrap: wrap;
        animation: fadeInUp 1s ease 0.6s both;
    }

    .hero-btn {
        padding: 15px 30px;
        font-size: 1.1em;
        border-radius: 50px;
        text-decoration: none;
        transition: all 0.3s ease;
        font-weight: 600;
    }

    .hero-btn.primary {
        background: white;
        color: #b3456b;
    }

    .hero-btn.primary:hover {
        transform: translateY(-3px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.2);
    }

    .hero-btn.secondary {
        background: transparent;
        color: white;
        border: 2px solid white;
    }

    .hero-btn.secondary:hover {
        background: white;
        color: #b3456b;
        transform: translateY(-3px);
    }

    .hero-btn.outline {
        background: rgba(255,255,255,0.2);
        color: white;
        border: 2px solid white;
    }

    .hero-btn.outline:hover {
        background: white;
        color: #b3456b;
        transform: translateY(-3px);
    }

    /* Общие стили секций */
    section {
        padding: 80px 0;
    }

    .section-header {
        text-align: center;
        margin-bottom: 50px;
    }

    .section-header h2 {
        color: #b3456b;
        font-size: 2.5em;
        font-weight: 600;
        margin-bottom: 15px;
    }

    .divider {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }

    .divider::before,
    .divider::after {
        content: '';
        width: 50px;
        height: 2px;
        background: #f0d9e3;
    }

    .divider-icon {
        font-size: 1.5em;
    }

    /* О салоне */
    .about-section {
        background: linear-gradient(135deg, #fff5f8, #fff);
    }

    .about-content {
        display: flex;
        gap: 50px;
        align-items: center;
        flex-wrap: wrap;
    }

    .about-text {
        flex: 2;
        font-size: 1.1em;
        line-height: 1.8;
        color: #666;
    }

    .about-stats {
        flex: 1;
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 20px;
    }

    .stat-item {
        text-align: center;
        padding: 20px;
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(179, 69, 107, 0.1);
    }

    .stat-number {
        font-size: 2.5em;
        font-weight: 700;
        color: #b3456b;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #a65a72;
        font-size: 0.9em;
    }

    /* Слайдер */
    .promo-section {
        background: #fff;
    }

    .promo-slider {
        position: relative;
        max-width: 1000px;
        margin: 0 auto;
        overflow: hidden;
    }

    .slider-container {
        overflow: hidden;
    }

    .slider-track {
        display: flex;
        transition: transform 0.5s ease;
    }

    .slide {
        flex: 0 0 calc(33.333% - 20px);
        margin: 0 10px;
    }

    .promo-card {
        background: linear-gradient(135deg, #fff5f8, #ffe4ed);
        border-radius: 20px;
        padding: 30px 20px;
        text-align: center;
        position: relative;
        box-shadow: 0 10px 20px rgba(179, 69, 107, 0.1);
        height: 250px;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .promo-badge {
        position: absolute;
        top: -10px;
        right: 20px;
        background: #b3456b;
        color: white;
        padding: 8px 15px;
        border-radius: 25px;
        font-weight: 600;
        font-size: 1em;
        box-shadow: 0 5px 10px rgba(179, 69, 107, 0.3);
    }

    .promo-card h3 {
        color: #b3456b;
        margin-bottom: 10px;
        font-size: 1.3em;
    }

    .promo-card p {
        color: #666;
        margin-bottom: 15px;
    }

    .promo-valid {
        color: #a65a72;
        font-size: 0.85em;
    }

    .slider-btn {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        background: white;
        border: none;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        box-shadow: 0 5px 10px rgba(0,0,0,0.1);
        cursor: pointer;
        font-size: 1.2em;
        color: #b3456b;
        transition: all 0.3s ease;
        z-index: 10;
    }

    .slider-btn:hover {
        background: #b3456b;
        color: white;
    }

    .slider-btn.prev {
        left: 10px;
    }

    .slider-btn.next {
        right: 10px;
    }

    .slider-dots {
        display: flex;
        justify-content: center;
        gap: 10px;
        margin-top: 20px;
    }

    .dot {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        background: #f0d9e3;
        cursor: pointer;
        transition: all 0.3s ease;
    }

    .dot.active {
        background: #b3456b;
        width: 20px;
        border-radius: 10px;
    }

    /* Услуги */
    .services-section {
        background: linear-gradient(135deg, #fff, #fff5f8);
    }

    .services-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
    }

    .service-card {
        background: white;
        border-radius: 20px;
        padding: 30px;
        text-align: center;
        box-shadow: 0 10px 20px rgba(179, 69, 107, 0.1);
        transition: all 0.3s ease;
    }

    .service-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 30px rgba(179, 69, 107, 0.2);
    }

    .service-icon {
        font-size: 3em;
        margin-bottom: 20px;
    }

    .service-card h3 {
        color: #b3456b;
        margin-bottom: 10px;
    }

    .service-card p {
        color: #666;
        margin-bottom: 20px;
    }

    .service-link {
        color: #b3456b;
        text-decoration: none;
        font-weight: 600;
        border-bottom: 2px solid transparent;
        transition: border-color 0.3s ease;
    }

    .service-link:hover {
        border-bottom-color: #b3456b;
    }

    /* История */
    .history-section {
        background: linear-gradient(135deg, #fff5f8, #fff);
    }

    .history-content {
        display: flex;
        gap: 50px;
        align-items: center;
        flex-wrap: wrap;
    }

    .history-text {
        flex: 1;
    }

    .history-text h2 {
        color: #b3456b;
        font-size: 2.5em;
        margin-bottom: 20px;
    }

    .history-text p {
        color: #666;
        line-height: 1.8;
        margin-bottom: 20px;
    }

    .history-text blockquote {
        font-size: 1.2em;
        font-style: italic;
        color: #a65a72;
        border-left: 4px solid #b3456b;
        padding-left: 20px;
        margin: 30px 0;
    }

    .history-text cite {
        display: block;
        margin-top: 10px;
        font-size: 0.9em;
        color: #b3456b;
    }

    .history-image {
        flex: 1;
        min-height: 300px;
        background: #f0d9e3;
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
    }

    .placeholder-image {
        font-size: 3em;
        color: #b3456b;
    }

    /* Команда */
    .team-section {
        background: linear-gradient(135deg, #fff, #fff5f8);
        text-align: center;
    }

    .team-preview {
        max-width: 600px;
        margin: 0 auto;
    }

    .team-preview p {
        font-size: 1.2em;
        color: #666;
        margin-bottom: 30px;
    }

    .team-btn {
        background: transparent;
        border: 2px solid #b3456b;
        color: #b3456b;
        padding: 12px 30px;
        border-radius: 50px;
        font-size: 1.1em;
        font-weight: 600;
        text-decoration: none;
        transition: all 0.3s ease;
    }

    .team-btn:hover {
        background: #b3456b;
        color: white;
        transform: translateY(-3px);
    }

    /* Контакты */
    .contacts-section {
        background: linear-gradient(135deg, #fff5f8, #fff);
    }

    .contacts-content {
        display: flex;
        gap: 50px;
        flex-wrap: wrap;
    }

    .contact-info {
        flex: 1;
        min-width: 300px;
    }

    .contact-item {
        display: flex;
        gap: 20px;
        margin-bottom: 30px;
        padding: 20px;
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 15px rgba(179, 69, 107, 0.1);
    }

    .contact-icon {
        font-size: 2em;
        color: #b3456b;
    }

    .contact-item h4 {
        color: #b3456b;
        margin-bottom: 5px;
    }

    .contact-item p {
        color: #666;
    }

    .contact-item a {
        color: #b3456b;
        text-decoration: none;
    }

    .contact-item a:hover {
        text-decoration: underline;
    }

    .contact-map {
        flex: 1;
        min-width: 300px;
    }

    .map-placeholder {
        background: #f0d9e3;
        border-radius: 20px;
        overflow: hidden;
        height: 300px;
    }

    /* Анимации */
    @keyframes fadeInDown {
        from {
            opacity: 0;
            transform: translateY(-30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .hero-title {
            font-size: 2.5em;
        }

        .hero-subtitle {
            font-size: 1.2em;
        }

        .hero-buttons {
            flex-direction: column;
        }

        .slide {
            flex: 0 0 calc(100% - 20px);
        }

        .about-content,
        .history-content,
        .contacts-content {
            flex-direction: column;
        }

        .about-stats {
            width: 100%;
        }

        .section-header h2 {
            font-size: 2em;
        }
    }
CSS;

$this->registerCss($css);

$js = <<< JS
    // Слайдер
    const slider = document.getElementById('promoSlider');
    const slides = document.querySelectorAll('.slide');
    const prevBtn = document.getElementById('sliderPrev');
    const nextBtn = document.getElementById('sliderNext');
    const dotsContainer = document.getElementById('sliderDots');
    
    let currentIndex = 0;
    const slidesCount = slides.length;
    const slidesPerView = window.innerWidth <= 768 ? 1 : 3;
    
    // Создаем dots
    for (let i = 0; i < Math.ceil(slidesCount / slidesPerView); i++) {
        const dot = document.createElement('span');
        dot.classList.add('dot');
        dot.addEventListener('click', () => goToSlide(i));
        dotsContainer.appendChild(dot);
    }
    
    function updateSlider() {
        const slideWidth = slides[0].offsetWidth + 20; // width + margin
        slider.style.transform = `translateX(-\${currentIndex * slideWidth}px)`;
        
        // Обновляем dots
        document.querySelectorAll('.dot').forEach((dot, i) => {
            dot.classList.toggle('active', i === currentIndex);
        });
    }
    
    function goToSlide(index) {
        currentIndex = index;
        updateSlider();
    }
    
    prevBtn.addEventListener('click', () => {
        if (currentIndex > 0) {
            currentIndex--;
            updateSlider();
        }
    });
    
    nextBtn.addEventListener('click', () => {
        const maxIndex = Math.ceil(slidesCount / slidesPerView) - 1;
        if (currentIndex < maxIndex) {
            currentIndex++;
            updateSlider();
        }
    });
    
    // Обновляем при изменении размера окна
    window.addEventListener('resize', () => {
        const newSlidesPerView = window.innerWidth <= 768 ? 1 : 3;
        if (newSlidesPerView !== slidesPerView) {
            location.reload();
        }
    });
    
    // Инициализация
    updateSlider();
JS;

$this->registerJs($js);
?>