<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Запись #' . $appointment->id;
$this->params['breadcrumbs'][] = ['label' => 'Мой профиль', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => 'История записей', 'url' => ['history']];
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="profile-view-appointment">
        <h1><?= Html::encode($this->title) ?></h1>

        <div class="row">
            <div class="col-md-8">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Детали записи</h3>
                    </div>
                    <div class="panel-body">
                        <table class="table table-bordered">
                            <tr>
                                <th style="width: 200px;">ID записи</th>
                                <td>#<?= $appointment->id ?></td>
                            </tr>
                            <tr>
                                <th>Дата создания</th>
                                <td><?= Yii::$app->formatter->asDatetime($appointment->created_at) ?></td>
                            </tr>
                            <tr>
                                <th>Статус</th>
                                <td>
                                    <?php if ($appointment->status == 0): ?>
                                        <span class="label label-warning">Новая</span>
                                    <?php elseif ($appointment->status == 1): ?>
                                        <span class="label label-success">Подтверждена</span>
                                    <?php elseif ($appointment->status == 2): ?>
                                        <span class="label label-danger">Отменена</span>
                                    <?php elseif ($appointment->status == 3): ?>
                                        <span class="label label-default">Завершена</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>Дата и время</th>
                                <td>
                                    <?= Yii::$app->formatter->asDatetime($appointment->start_time) ?>
                                    <br>
                                    <small class="text-muted">
                                        Окончание: <?= Yii::$app->formatter->asTime($appointment->end_time) ?>
                                    </small>
                                </td>
                            </tr>
                            <tr>
                                <th>Длительность</th>
                                <td><?= Yii::$app->formatter->asDuration(strtotime($appointment->end_time) - strtotime($appointment->start_time)) ?></td>
                            </tr>
                            <tr>
                                <th>Способ оплаты</th>
                                <td>
                                    <?php
                                    $methods = ['cash' => 'Наличные', 'card' => 'Карта', 'online' => 'Онлайн'];
                                    echo $methods[$appointment->payment_method] ?? $appointment->payment_method;
                                    ?>
                                </td>
                            </tr>
                            <?php if ($appointment->additional_info): ?>
                                <tr>
                                    <th>Комментарий</th>
                                    <td><?= nl2br(Html::encode($appointment->additional_info)) ?></td>
                                </tr>
                            <?php endif; ?>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <!-- Информация о мастере -->
                <div class="panel panel-info">
                    <div class="panel-heading">
                        <h3 class="panel-title">Мастер</h3>
                    </div>
                    <div class="panel-body text-center">
                        <div class="avatar-circle" style="width: 100px; height: 100px; background: #5bc0de; border-radius: 50%; margin: 0 auto 15px; display: flex; align-items: center; justify-content: center; color: white; font-size: 40px;">
                            <?= strtoupper(substr($appointment->masterInfo->user->name, 0, 1)) ?>
                        </div>

                        <h4><?= Html::encode($appointment->masterInfo->user->surname . ' ' . $appointment->masterInfo->user->name) ?></h4>

                        <?php if ($appointment->masterInfo->specialization): ?>
                            <p class="text-muted"><?= Html::encode($appointment->masterInfo->specialization) ?></p>
                        <?php endif; ?>

                        <p>
                            <?= Html::a('Страница мастера', ['/master/view', 'id' => $appointment->masterInfo->user->id], [
                                'class' => 'btn btn-sm btn-primary'
                            ]) ?>
                        </p>
                    </div>
                </div>

                <!-- Информация об услуге -->
                <div class="panel panel-success">
                    <div class="panel-heading">
                        <h3 class="panel-title">Услуга</h3>
                    </div>
                    <div class="panel-body">
                        <h4><?= Html::encode($appointment->service->name) ?></h4>

                        <?php if ($appointment->service->description): ?>
                            <p><?= Html::encode($appointment->service->description) ?></p>
                        <?php endif; ?>

                        <table class="table">
                            <tr>
                                <th>Длительность</th>
                                <td><?= $appointment->service->duration ?> мин.</td>
                            </tr>
                            <tr>
                                <th>Цена</th>
                                <td><strong><?= $appointment->service->price ?> руб.</strong></td>
                            </tr>
                        </table>
                    </div>
                </div>

                <!-- Действия -->
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">Действия</h3>
                    </div>
                    <div class="panel-body">
                        <?php if (in_array($appointment->status, [0, 1])): ?>
                            <button class="btn btn-danger btn-block cancel-appointment" data-id="<?= $appointment->id ?>">
                                <i class="glyphicon glyphicon-remove"></i> Отменить запись
                            </button>
                        <?php endif; ?>

                        <?= Html::a('Назад к истории', ['history'], ['class' => 'btn btn-default btn-block']) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$cancelUrl = Url::to(['profile/cancel-appointment']);
$script = <<< JS
    // Отмена заявки
    $('.cancel-appointment').on('click', function() {
        var id = $(this).data('id');
        
        if (confirm('Отменить эту запись?')) {
            $.ajax({
                url: '$cancelUrl',
                type: 'POST',
                data: {id: id},
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        alert('Запись отменена');
                        location.reload();
                    } else {
                        alert(response.message);
                    }
                }
            });
        }
    });
JS;

$this->registerJs($script);
?>