<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Мои услуги';
?>

<div class="master-services">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="alert alert-success">
            <?= Yii::$app->session->getFlash('success') ?>
        </div>
    <?php endif; ?>

    <?php $form = ActiveForm::begin(); ?>

    <table class="table table-striped">
        <thead>
        <tr>
            <th>Выбрать</th>
            <th>Услуга</th>
            <th>Цена</th>
            <th>Длительность</th>
            <th>Наценка/скидка</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($allServices as $service): ?>
            <?php $checked = isset($selectedServices[$service->id]); ?>
            <tr>
                <td>
                    <input type="checkbox"
                           name="service[<?= $service->id ?>][selected]"
                           value="1"
                        <?= $checked ? 'checked' : '' ?>>
                </td>
                <td><?= Html::encode($service->name) ?></td>
                <td><?= $service->price ?> руб.</td>
                <td><?= $service->duration ?> мин.</td>
                <td>
                    <input type="number"
                           name="service[<?= $service->id ?>][modifier]"
                           value="<?= $checked ? $selectedServices[$service->id]->price_modifier : 0 ?>"
                           step="0.01"
                           class="form-control"
                           style="width: 100px;">
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

    <div class="form-group">
        <?= Html::submitButton('Сохранить', ['class' => 'btn btn-success']) ?>
        <?= Html::a('Отмена', ['index'], ['class' => 'btn btn-default']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>