<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Моё расписание';
$this->params['breadcrumbs'][] = ['label' => 'Панель мастера', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="master-schedule">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="alert alert-success">
            <?= Yii::$app->session->getFlash('success') ?>
        </div>
    <?php endif; ?>

    <?php if (Yii::$app->session->hasFlash('error')): ?>
        <div class="alert alert-danger">
            <?= Yii::$app->session->getFlash('error') ?>
        </div>
    <?php endif; ?>

    <div class="panel panel-default">
        <div class="panel-body">

            <?php $form = ActiveForm::begin(); ?>

            <table class="table table-bordered">
                <thead>
                <tr>
                    <th width="50px">Работаю</th>
                    <th>День недели</th>
                    <th>Начало работы</th>
                    <th>Окончание работы</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($days as $dayNum => $dayName): ?>
                    <?php
                    $schedule = isset($schedules[$dayNum]) ? $schedules[$dayNum] : null;
                    $isWorking = $schedule ? true : false;
                    $startTime = $schedule ? $schedule->start_time : '09:00';
                    $endTime = $schedule ? $schedule->end_time : '20:00';
                    ?>
                    <tr>
                        <td class="text-center">
                            <input type="checkbox"
                                   name="schedule[<?= $dayNum ?>][is_working]"
                                   value="1"
                                <?= $isWorking ? 'checked' : '' ?>
                                   class="day-checkbox"
                                   data-day="<?= $dayNum ?>">
                        </td>
                        <td>
                            <strong><?= $dayName ?></strong>
                        </td>
                        <td>
                            <input type="time"
                                   name="schedule[<?= $dayNum ?>][start_time]"
                                   value="<?= $startTime ?>"
                                   class="form-control start-time"
                                   data-day="<?= $dayNum ?>"
                                   style="width: 120px;"
                                <?= !$isWorking ? 'disabled' : '' ?>>
                        </td>
                        <td>
                            <input type="time"
                                   name="schedule[<?= $dayNum ?>][end_time]"
                                   value="<?= $endTime ?>"
                                   class="form-control end-time"
                                   data-day="<?= $dayNum ?>"
                                   style="width: 120px;"
                                <?= !$isWorking ? 'disabled' : '' ?>>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>

            <div class="form-group">
                <?= Html::submitButton('Сохранить расписание', ['class' => 'btn btn-success']) ?>
                <?= Html::a('Отмена', ['index'], ['class' => 'btn btn-default']) ?>
            </div>

            <?php ActiveForm::end(); ?>

        </div>
    </div>
</div>

<script>
    // Простой JavaScript для включения/отключения полей
    document.querySelectorAll('.day-checkbox').forEach(function(checkbox) {
        checkbox.addEventListener('change', function() {
            var day = this.dataset.day;
            var startTime = document.querySelector('.start-time[data-day="' + day + '"]');
            var endTime = document.querySelector('.end-time[data-day="' + day + '"]');

            startTime.disabled = !this.checked;
            endTime.disabled = !this.checked;
        });
    });
</script>