<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Редактирование профиля';
$this->params['breadcrumbs'][] = ['label' => 'Панель мастера', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="master-profile">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="row">
        <div class="col-lg-8">
            <div class="panel panel-default">
                <div class="panel-body">

                    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>

                    <div class="row">
                        <div class="col-lg-6">
                            <?= $form->field($user, 'surname')->textInput(['readonly' => true]) ?>
                        </div>
                        <div class="col-lg-6">
                            <?= $form->field($user, 'name')->textInput(['readonly' => true]) ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-6">
                            <?= $form->field($user, 'patronymic')->textInput(['readonly' => true]) ?>
                        </div>
                        <div class="col-lg-6">
                            <?= $form->field($user, 'phone_number')->textInput(['readonly' => true]) ?>
                        </div>
                    </div>

                    <hr>

                    <?= $form->field($masterInfo, 'specialization')->textarea(['rows' => 2]) ?>

                    <?= $form->field($masterInfo, 'bio')->textarea(['rows' => 5]) ?>

                    <div class="row">
                        <div class="col-lg-6">
                            <?= $form->field($masterInfo, 'experience_years')->textInput(['type' => 'number', 'min' => 0]) ?>
                        </div>
                        <div class="col-lg-6">
                            <?= $form->field($masterInfo, 'certificate_expiry')->input('date') ?>
                        </div>
                    </div>

                    <?= $form->field($masterInfo, 'certificate_photo')->fileInput(['accept' => 'image/*']) ?>

                    <?php if ($masterInfo->certificate_photo): ?>
                        <div class="form-group">
                            <label>Текущий сертификат</label>
                            <div>
                                <a href="/<?= $masterInfo->certificate_photo ?>" target="_blank">
                                    <img src="/<?= $masterInfo->certificate_photo ?>" style="max-width: 200px; max-height: 150px;">
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?= $form->field($masterInfo, 'is_active')->checkbox() ?>

                    <div class="form-group">
                        <?= Html::submitButton('Сохранить', ['class' => 'btn btn-success']) ?>
                        <?= Html::a('Отмена', ['index'], ['class' => 'btn btn-default']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>

                </div>
            </div>
        </div>
    </div>
</div>