<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Моё портфолио';
$this->params['breadcrumbs'][] = ['label' => 'Панель мастера', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="master-portfolio">
        <h1><?= Html::encode($this->title) ?></h1>

        <div class="alert alert-info">
            <i class="glyphicon glyphicon-info-sign"></i>
            Здесь вы можете добавить фото ваших работ. Клиенты увидят их на вашей странице.
        </div>

        <!-- Блок для уведомлений -->
        <div id="portfolio-message" style="display: none; margin-bottom: 15px;"></div>

        <!-- Форма загрузки нового фото -->
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Добавить новое фото</h3>
            </div>
            <div class="panel-body">
                <form id="upload-form" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="portfolio-image" class="control-label">Выберите фото</label>
                                <input type="file" id="portfolio-image" name="imageFile" accept="image/*" class="form-control" required>
                                <p class="help-block">Разрешены: jpg, png, webp. Максимальный размер 5 МБ</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="portfolio-description" class="control-label">Описание (необязательно)</label>
                                <textarea id="portfolio-description" name="description" class="form-control" rows="3" placeholder="Например: До/После, техника выполнения..."></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <button type="submit" class="btn btn-success" id="upload-btn">
                            <i class="glyphicon glyphicon-upload"></i> Загрузить фото
                        </button>
                    </div>
                </form>

                <!-- Прогресс бар для загрузки -->
                <div id="upload-progress" style="display: none; margin-top: 10px;">
                    <div class="progress">
                        <div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" style="width: 0%">
                            <span class="sr-only">0%</span>
                        </div>
                    </div>
                    <p class="text-center" id="progress-text">Загрузка...</p>
                </div>
            </div>
        </div>

        <!-- Галерея портфолио -->
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Мои работы (<?= count($portfolio) ?>)</h3>
            </div>
            <div class="panel-body">

                <?php if (empty($portfolio)): ?>
                    <p class="text-muted text-center" style="padding: 30px;">
                        <i class="glyphicon glyphicon-picture" style="font-size: 48px; display: block; margin-bottom: 10px;"></i>
                        У вас пока нет фото в портфолио. Добавьте первое фото!
                    </p>
                <?php else: ?>
                    <div class="row" id="portfolio-gallery">
                        <?php foreach ($portfolio as $photo): ?>
                            <div class="col-md-3 col-sm-4 col-xs-6 portfolio-item" id="portfolio-<?= $photo->id ?>">
                                <div class="thumbnail">
                                    <div style="position: relative;">
                                        <img src="/<?= $photo->photo_url ?>" style="height: 180px; width: 100%; object-fit: cover; cursor: pointer;"
                                             class="portfolio-img" data-id="<?= $photo->id ?>" data-description="<?= Html::encode($photo->description) ?>">

                                        <!-- Кнопки управления -->
                                        <div style="position: absolute; top: 5px; right: 5px;">
                                            <button class="btn btn-xs btn-danger delete-photo" data-id="<?= $photo->id ?>" title="Удалить">
                                                <i class="glyphicon glyphicon-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="caption">
                                        <div class="photo-description" data-id="<?= $photo->id ?>">
                                            <?php if ($photo->description): ?>
                                                <p><?= Html::encode($photo->description) ?></p>
                                            <?php else: ?>
                                                <p class="text-muted"><em>Нет описания</em></p>
                                            <?php endif; ?>
                                        </div>

                                        <!-- Форма редактирования описания (скрыта) -->
                                        <div class="edit-description-form" data-id="<?= $photo->id ?>" style="display: none;">
                                            <textarea class="form-control edit-description-text" rows="2"><?= Html::encode($photo->description) ?></textarea>
                                            <div style="margin-top: 5px;">
                                                <button class="btn btn-xs btn-success save-description" data-id="<?= $photo->id ?>">Сохранить</button>
                                                <button class="btn btn-xs btn-default cancel-edit" data-id="<?= $photo->id ?>">Отмена</button>
                                            </div>
                                        </div>

                                        <div class="text-center" style="margin-top: 5px;">
                                            <button class="btn btn-xs btn-primary edit-description-btn" data-id="<?= $photo->id ?>">
                                                <i class="glyphicon glyphicon-pencil"></i> Редактировать описание
                                            </button>
                                        </div>
                                        <p class="text-muted text-center" style="font-size: 11px; margin-top: 5px;">
                                            Добавлено: <?= Yii::$app->formatter->asDate($photo->created_at) ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>

    <!-- Модальное окно для просмотра фото -->
    <div class="modal fade" id="photo-modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title">Просмотр фото</h4>
                </div>
                <div class="modal-body text-center">
                    <img src="" id="modal-image" style="max-width: 100%; max-height: 500px;">
                    <p id="modal-description" class="text-muted" style="margin-top: 10px;"></p>
                </div>
            </div>
        </div>
    </div>

<?php
$uploadUrl = Url::to(['master/upload-portfolio']);
$deleteUrl = Url::to(['master/delete-portfolio']);
$updateDescUrl = Url::to(['master/update-portfolio-description']);

$script = <<< JS
    $('#upload-form').on('submit', function(e) {
        e.preventDefault();
        
        var formData = new FormData(this);
        var messageDiv = $('#portfolio-message');
        var uploadBtn = $('#upload-btn');
        var progress = $('#upload-progress');
        var progressBar = progress.find('.progress-bar');
        var progressText = $('#progress-text');
        
        messageDiv.hide().removeClass('alert-success alert-danger');
        uploadBtn.prop('disabled', true).html('<i class="glyphicon glyphicon-refresh spinning"></i> Загрузка...');
        progress.show();
        progressBar.css('width', '0%').text('0%');
        progressText.text('Загрузка...');
        
        $.ajax({
            url: '$uploadUrl',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            xhr: function() {
                var xhr = new window.XMLHttpRequest();
                xhr.upload.addEventListener('progress', function(e) {
                    if (e.lengthComputable) {
                        var percent = Math.round((e.loaded / e.total) * 100);
                        progressBar.css('width', percent + '%').text(percent + '%');
                        progressText.text('Загружено ' + percent + '%');
                    }
                }, false);
                return xhr;
            },
            success: function(response) {
                if (response.success) {
                    messageDiv.addClass('alert alert-success').html('<i class="glyphicon glyphicon-ok"></i> ' + response.message).fadeIn();
                    if (response.photo) {
                        var newPhoto = createPhotoElement(response.photo);
                        $('#portfolio-gallery').prepend(newPhoto);
                        if ($('#portfolio-gallery').find('.text-muted').length > 0) {
                            $('#portfolio-gallery').empty();
                        }
                    }
                    
                    // Очищаем форму
                    $('#upload-form')[0].reset();
                    
                    // Обновляем счетчик
                    updatePhotoCount();
                    
                    setTimeout(function() {
                        messageDiv.fadeOut();
                    }, 3000);
                } else {
                    messageDiv.addClass('alert alert-danger').html('<i class="glyphicon glyphicon-exclamation-sign"></i> ' + (response.message || 'Ошибка загрузки')).fadeIn();
                }
                uploadBtn.prop('disabled', false).html('<i class="glyphicon glyphicon-upload"></i> Загрузить фото');
                progress.hide();
            },
            error: function() {
                messageDiv.addClass('alert alert-danger').html('<i class="glyphicon glyphicon-exclamation-sign"></i> Ошибка соединения с сервером').fadeIn();
                uploadBtn.prop('disabled', false).html('<i class="glyphicon glyphicon-upload"></i> Загрузить фото');
                progress.hide();
            }
        });
    });
    
    // Функция создания элемента фото
    function createPhotoElement(photo) {
        var date = new Date();
        var formattedDate = date.toLocaleDateString('ru-RU');
        
        return '<div class="col-md-3 col-sm-4 col-xs-6 portfolio-item" id="portfolio-' + photo.id + '">' +
            '<div class="thumbnail">' +
            '<div style="position: relative;">' +
            '<img src="' + photo.url + '" style="height: 180px; width: 100%; object-fit: cover; cursor: pointer;" ' +
            'class="portfolio-img" data-id="' + photo.id + '" data-description="' + (photo.description || '') + '">' +
            '<div style="position: absolute; top: 5px; right: 5px;">' +
            '<button class="btn btn-xs btn-danger delete-photo" data-id="' + photo.id + '" title="Удалить">' +
            '<i class="glyphicon glyphicon-trash"></i>' +
            '</button>' +
            '</div>' +
            '</div>' +
            '<div class="caption">' +
            '<div class="photo-description" data-id="' + photo.id + '">' +
            (photo.description ? '<p>' + photo.description + '</p>' : '<p class="text-muted"><em>Нет описания</em></p>') +
            '</div>' +
            '<div class="edit-description-form" data-id="' + photo.id + '" style="display: none;">' +
            '<textarea class="form-control edit-description-text" rows="2">' + (photo.description || '') + '</textarea>' +
            '<div style="margin-top: 5px;">' +
            '<button class="btn btn-xs btn-success save-description" data-id="' + photo.id + '">Сохранить</button>' +
            '<button class="btn btn-xs btn-default cancel-edit" data-id="' + photo.id + '">Отмена</button>' +
            '</div>' +
            '</div>' +
            '<div class="text-center" style="margin-top: 5px;">' +
            '<button class="btn btn-xs btn-primary edit-description-btn" data-id="' + photo.id + '">' +
            '<i class="glyphicon glyphicon-pencil"></i> Редактировать описание' +
            '</button>' +
            '</div>' +
            '<p class="text-muted text-center" style="font-size: 11px; margin-top: 5px;">' +
            'Добавлено: ' + photo.date +
            '</p>' +
            '</div>' +
            '</div>' +
            '</div>';
    }
    
    // Функция обновления счетчика фото
    function updatePhotoCount() {
        var count = $('.portfolio-item').length;
        $('.panel-title:contains("Мои работы")').text('Мои работы (' + count + ')');
    }
    
    // Удаление фото
    $(document).on('click', '.delete-photo', function() {
        var id = $(this).data('id');
        var messageDiv = $('#portfolio-message');
        
        if (confirm('Удалить это фото из портфолио?')) {
            $.ajax({
                url: '$deleteUrl',
                type: 'POST',
                data: {id: id},
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        $('#portfolio-' + id).fadeOut(300, function() {
                            $(this).remove();
                            updatePhotoCount();
                            
                            // Если фото закончились, показываем заглушку
                            if ($('.portfolio-item').length === 0) {
                                $('#portfolio-gallery').html(
                                    '<p class="text-muted text-center" style="padding: 30px;">' +
                                    '<i class="glyphicon glyphicon-picture" style="font-size: 48px; display: block; margin-bottom: 10px;"></i>' +
                                    'У вас пока нет фото в портфолио. Добавьте первое фото!' +
                                    '</p>'
                                );
                            }
                        });
                        
                        messageDiv.addClass('alert alert-success').html('<i class="glyphicon glyphicon-ok"></i> ' + response.message).fadeIn();
                        setTimeout(function() {
                            messageDiv.fadeOut();
                        }, 2000);
                    } else {
                        messageDiv.addClass('alert alert-danger').html('<i class="glyphicon glyphicon-exclamation-sign"></i> ' + (response.message || 'Ошибка удаления')).fadeIn();
                    }
                }
            });
        }
    });
    
    // Редактирование описания - показать форму
    $(document).on('click', '.edit-description-btn', function() {
        var id = $(this).data('id');
        $('.photo-description[data-id="' + id + '"]').hide();
        $('.edit-description-form[data-id="' + id + '"]').show();
        $(this).hide();
    });
    
    // Отмена редактирования
    $(document).on('click', '.cancel-edit', function() {
        var id = $(this).data('id');
        $('.photo-description[data-id="' + id + '"]').show();
        $('.edit-description-form[data-id="' + id + '"]').hide();
        $('.edit-description-btn[data-id="' + id + '"]').show();
    });
    
    // Сохранение описания
    $(document).on('click', '.save-description', function() {
        var id = $(this).data('id');
        var description = $('.edit-description-form[data-id="' + id + '"] .edit-description-text').val();
        var messageDiv = $('#portfolio-message');
        
        $.ajax({
            url: '$updateDescUrl',
            type: 'POST',
            data: {
                id: id,
                description: description
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    // Обновляем отображение
                    var descHtml = description ? '<p>' + description + '</p>' : '<p class="text-muted"><em>Нет описания</em></p>';
                    $('.photo-description[data-id="' + id + '"]').html(descHtml);
                    
                    $('.photo-description[data-id="' + id + '"]').show();
                    $('.edit-description-form[data-id="' + id + '"]').hide();
                    $('.edit-description-btn[data-id="' + id + '"]').show();
                    
                    messageDiv.addClass('alert alert-success').html('<i class="glyphicon glyphicon-ok"></i> ' + response.message).fadeIn();
                    setTimeout(function() {
                        messageDiv.fadeOut();
                    }, 2000);
                } else {
                    messageDiv.addClass('alert alert-danger').html('<i class="glyphicon glyphicon-exclamation-sign"></i> ' + (response.message || 'Ошибка')).fadeIn();
                }
            }
        });
    });
    
    // Просмотр фото в модальном окне
    $(document).on('click', '.portfolio-img', function() {
        var src = $(this).attr('src');
        var description = $(this).data('description');
        
        $('#modal-image').attr('src', src);
        $('#modal-description').text(description || '');
        $('#photo-modal').modal('show');
    });
    
    // Стили для анимации загрузки
    $('<style>')
        .prop('type', 'text/css')
        .html('\
            .spinning {\
                animation: spin 1s infinite linear;\
            }\
            @keyframes spin {\
                from { transform: scale(1) rotate(0deg); }\
                to { transform: scale(1) rotate(360deg); }\
            }\
        ')
        .appendTo('head');
JS;

$this->registerJs($script);
?>