<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = $service->name;
$this->params['breadcrumbs'][] = ['label' => 'Каталог услуг', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="beauty-service-view">
        <div class="service-header">
            <h1><?= Html::encode($service->name) ?></h1>
            <div class="divider">
                <span class="divider-icon">✨</span>
            </div>
        </div>

        <div class="service-container">
            <div class="row">
                <!-- Основная информация об услуге -->
                <div class="col-md-8">
                    <div class="service-main-card">
                        <div class="service-main-header">
                            <h2>Информация об услуге</h2>
                            <?php if ($service->category): ?>
                                <span class="category-badge"><?= Html::encode($service->category->name) ?></span>
                            <?php endif; ?>
                        </div>

                        <div class="service-main-body">
                            <?php if ($service->description): ?>
                                <div class="service-description">
                                    <h3>Описание</h3>
                                    <p><?= nl2br(Html::encode($service->description)) ?></p>
                                </div>
                            <?php endif; ?>

                            <div class="service-stats">
                                <div class="stat-card">
                                    <div class="stat-icon">⏱️</div>
                                    <div class="stat-label">Длительность</div>
                                    <div class="stat-value"><?= $service->duration ?> мин</div>
                                </div>
                                <div class="stat-card">
                                    <div class="stat-icon">💰</div>
                                    <div class="stat-label">Цена</div>
                                    <div class="stat-value"><?= $service->price ?> ₽</div>
                                </div>
                                <div class="stat-card">
                                    <div class="stat-icon">👥</div>
                                    <div class="stat-label">Мастеров</div>
                                    <div class="stat-value"><?= count($masters) ?></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Мастера, выполняющие эту услугу -->
                    <div class="masters-section">
                        <div class="section-header">
                            <h2>Мастера, выполняющие эту услугу</h2>
                            <div class="section-divider"></div>
                        </div>

                        <?php if (empty($masters)): ?>
                            <div class="empty-state">
                                <div class="empty-icon">😔</div>
                                <p>К сожалению, сейчас нет мастеров для этой услуги.</p>
                            </div>
                        <?php else: ?>
                            <div class="masters-grid">
                                <?php foreach ($masters as $master): ?>
                                    <?php
                                    $finalPrice = $service->price + ($master->price_modifier ?? 0);
                                    $masterInfo = \app\models\MasterInfo::find()
                                        ->where(['user_id' => $master->id])
                                        ->one();
                                    $colors = ['#9b59b6', '#b573c9', '#a569bd', '#c39bd3', '#d7bde2'];
                                    $colorIndex = ($master->id - 1) % count($colors);
                                    ?>
                                    <div class="master-card-wrapper">
                                        <div class="master-card" style="border-top-color: <?= $colors[$colorIndex] ?>;">
                                            <div class="master-card-header">
                                                <div class="master-avatar" style="background: <?= $colors[$colorIndex] ?>;">
                                                    <?= strtoupper(substr($master->name, 0, 1)) ?>
                                                </div>
                                                <h3 class="master-name">
                                                    <?= Html::encode($master->surname . ' ' . $master->name) ?>
                                                </h3>
                                            </div>

                                            <div class="master-card-body">
                                                <?php if ($masterInfo && $masterInfo->specialization): ?>
                                                    <div class="master-specialization">
                                                        <?= Html::encode($masterInfo->specialization) ?>
                                                    </div>
                                                <?php endif; ?>

                                                <div class="master-details">
                                                    <?php if ($masterInfo && $masterInfo->experience_years): ?>
                                                        <div class="detail-item">
                                                            <span class="detail-icon">⭐</span>
                                                            <span>Опыт: <?= $masterInfo->experience_years ?> лет</span>
                                                        </div>
                                                    <?php endif; ?>

                                                    <div class="detail-item price">
                                                        <span class="detail-icon">💰</span>
                                                        <span>Цена: <strong><?= $finalPrice ?> ₽</strong></span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="master-card-footer">
                                                <div class="master-actions">
                                                    <?= Html::a('Выбрать', ['/appointment/create'], [
                                                        'class' => 'btn choose-btn',
                                                        'data' => [
                                                            'method' => 'post',
                                                            'params' => [
                                                                'master_id' => $master->id,
                                                                'service_id' => $service->id
                                                            ]
                                                        ]
                                                    ]) ?>

                                                    <?= Html::a('Профиль', ['/master/view', 'id' => $master->id], [
                                                        'class' => 'btn profile-btn'
                                                    ]) ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Боковая панель -->
                <div class="col-md-4">
                    <!-- Быстрая запись -->
                    <div class="quick-booking-card">
                        <div class="quick-booking-header">
                            <h3>✨ Быстрая запись</h3>
                        </div>
                        <div class="quick-booking-body">
                            <p>Хотите записаться на эту услугу?</p>
                            <?php if (!empty($masters)): ?>
                                <?= Html::a('Записаться онлайн', ['/appointment/create'], [
                                    'class' => 'booking-btn',
                                    'data' => [
                                        'method' => 'post',
                                        'params' => ['service_id' => $service->id]
                                    ]
                                ]) ?>
                                <p class="hint">Выберите мастера на следующем шаге</p>
                            <?php else: ?>
                                <button class="booking-btn disabled" disabled>Нет мастеров</button>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Похожие услуги -->
                    <?php if (!empty($similarServices)): ?>
                        <div class="similar-services-card">
                            <div class="similar-services-header">
                                <h3>🔗 Похожие услуги</h3>
                            </div>
                            <div class="similar-services-body">
                                <?php foreach ($similarServices as $index => $similar): ?>
                                    <div class="similar-item">
                                        <div class="similar-info">
                                            <h4 class="similar-name">
                                                <?= Html::a(Html::encode($similar->name), ['view', 'id' => $similar->id]) ?>
                                            </h4>
                                            <div class="similar-meta">
                                                <span class="meta-duration">⏱️ <?= $similar->duration ?> мин</span>
                                                <span class="meta-price">💰 <?= $similar->price ?> ₽</span>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if ($index < count($similarServices) - 1): ?>
                                        <div class="similar-divider"></div>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

<?php
$checkAvailabilityUrl = Url::to(['catalog/check-availability']);
$js = <<< JS
    // Проверка доступности мастера (можно добавить позже)
    console.log('Страница услуги загружена');
JS;

$this->registerJs($js);

$css = <<< CSS
    .beauty-service-view {
        max-width: 1200px;
        margin: 0 auto;
        padding: 40px 20px;
        font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
    }

    .service-header {
        text-align: center;
        margin-bottom: 40px;
    }

    .service-header h1 {
        color: #9b59b6;
        font-size: 2.8em;
        font-weight: 600;
        margin-bottom: 15px;
        text-shadow: 2px 2px 4px rgba(155, 89, 182, 0.1);
    }

    .divider {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 15px;
        margin: 20px 0;
    }

    .divider::before,
    .divider::after {
        content: '';
        width: 80px;
        height: 2px;
        background: linear-gradient(90deg, transparent, #9b59b6, #d8b5e6, #9b59b6, transparent);
    }

    .divider-icon {
        font-size: 2em;
        color: #9b59b6;
    }

    /* Основная карточка услуги */
    .service-main-card {
        background: white;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(155, 89, 182, 0.15);
        overflow: hidden;
        margin-bottom: 30px;
    }

    .service-main-header {
        background: linear-gradient(135deg, #9b59b6, #d8b5e6);
        padding: 20px 25px;
        display: flex;
        align-items: center;
        justify-content: space-between;
        flex-wrap: wrap;
        gap: 15px;
    }

    .service-main-header h2 {
        color: white;
        margin: 0;
        font-size: 1.5em;
        font-weight: 600;
    }

    .category-badge {
        background: white;
        color: #9b59b6;
        padding: 6px 15px;
        border-radius: 50px;
        font-weight: 600;
        font-size: 0.95em;
    }

    .service-main-body {
        padding: 30px;
    }

    .service-description {
        margin-bottom: 30px;
    }

    .service-description h3 {
        color: #8e44ad;
        font-size: 1.3em;
        margin-bottom: 15px;
    }

    .service-description p {
        color: #666;
        line-height: 1.8;
        font-size: 1.1em;
    }

    .service-stats {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 20px;
    }

    .stat-card {
        background: linear-gradient(135deg, #faf5ff, white);
        border-radius: 15px;
        padding: 25px 15px;
        text-align: center;
        box-shadow: 0 5px 15px rgba(155, 89, 182, 0.1);
        transition: all 0.3s ease;
    }

    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(155, 89, 182, 0.2);
    }

    .stat-icon {
        font-size: 2.5em;
        margin-bottom: 10px;
        color: #9b59b6;
    }

    .stat-label {
        color: #8e44ad;
        font-size: 1em;
        margin-bottom: 10px;
    }

    .stat-value {
        color: #9b59b6;
        font-size: 2em;
        font-weight: 700;
    }

    /* Секция мастеров */
    .masters-section {
        background: white;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(155, 89, 182, 0.15);
        padding: 30px;
    }

    .section-header {
        text-align: center;
        margin-bottom: 30px;
    }

    .section-header h2 {
        color: #9b59b6;
        font-size: 2em;
        font-weight: 600;
        margin-bottom: 15px;
    }

    .section-divider {
        width: 80px;
        height: 3px;
        background: linear-gradient(90deg, #9b59b6, #d8b5e6);
        margin: 0 auto;
        border-radius: 3px;
    }

    .masters-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 20px;
    }

    .master-card-wrapper {
        animation: fadeInUp 0.5s ease forwards;
        opacity: 0;
    }

    .master-card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(155, 89, 182, 0.1);
        overflow: hidden;
        transition: all 0.3s ease;
        border-top: 4px solid #9b59b6;
        height: 100%;
        display: flex;
        flex-direction: column;
    }

    .master-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 30px rgba(155, 89, 182, 0.2);
    }

    .master-card-header {
        padding: 20px;
        text-align: center;
        border-bottom: 1px solid #f0e5f5;
    }

    .master-avatar {
        width: 70px;
        height: 70px;
        border-radius: 50%;
        margin: 0 auto 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 28px;
        font-weight: 600;
        box-shadow: 0 5px 15px rgba(155, 89, 182, 0.3);
    }

    .master-name {
        color: #8e44ad;
        margin: 0;
        font-size: 1.2em;
    }

    .master-card-body {
        padding: 20px;
        flex: 1;
    }

    .master-specialization {
        color: #9b59b6;
        font-size: 0.95em;
        text-align: center;
        margin-bottom: 15px;
        padding: 5px 10px;
        background: #faf5ff;
        border-radius: 50px;
    }

    .master-details {
        display: flex;
        flex-direction: column;
        gap: 8px;
    }

    .detail-item {
        display: flex;
        align-items: center;
        gap: 8px;
        color: #666;
        font-size: 0.95em;
    }

    .detail-item.price {
        color: #27ae60;
        font-weight: 600;
    }

    .detail-icon {
        font-size: 1.1em;
        min-width: 20px;
    }

    .master-card-footer {
        padding: 15px 20px;
        background: #faf5ff;
        border-top: 1px solid #f0e5f5;
    }

    .master-actions {
        display: flex;
        gap: 10px;
    }

    .choose-btn,
    .profile-btn {
        flex: 1;
        padding: 10px;
        border: none;
        border-radius: 10px;
        font-size: 0.95em;
        font-weight: 600;
        text-align: center;
        text-decoration: none;
        transition: all 0.3s ease;
        cursor: pointer;
    }

    .choose-btn {
        background: #9b59b6;
        color: white;
    }

    .choose-btn:hover {
        background: #8e44ad;
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(155, 89, 182, 0.4);
        color: white;
        text-decoration: none;
    }

    .profile-btn {
        background: white;
        color: #9b59b6;
        border: 2px solid #9b59b6;
    }

    .profile-btn:hover {
        background: #9b59b6;
        color: white;
        transform: translateY(-2px);
        text-decoration: none;
    }

    /* Быстрая запись */
    .quick-booking-card {
        background: white;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(155, 89, 182, 0.15);
        overflow: hidden;
        margin-bottom: 30px;
    }

    .quick-booking-header {
        background: linear-gradient(135deg, #9b59b6, #d8b5e6);
        padding: 20px;
    }

    .quick-booking-header h3 {
        color: white;
        margin: 0;
        font-size: 1.3em;
        text-align: center;
    }

    .quick-booking-body {
        padding: 25px;
        text-align: center;
    }

    .quick-booking-body p {
        color: #666;
        margin-bottom: 20px;
    }

    .booking-btn {
        display: block;
        width: 100%;
        padding: 15px;
        background: linear-gradient(135deg, #9b59b6, #d8b5e6);
        color: white;
        border: none;
        border-radius: 50px;
        font-size: 1.1em;
        font-weight: 600;
        text-decoration: none;
        transition: all 0.3s ease;
        cursor: pointer;
        margin-bottom: 10px;
    }

    .booking-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 20px rgba(155, 89, 182, 0.3);
        color: white;
        text-decoration: none;
    }

    .booking-btn.disabled {
        background: #e0e0e0;
        cursor: not-allowed;
    }

    .hint {
        color: #999;
        font-size: 0.9em;
        font-style: italic;
    }

    /* Похожие услуги */
    .similar-services-card {
        background: white;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(155, 89, 182, 0.15);
        overflow: hidden;
    }

    .similar-services-header {
        background: linear-gradient(135deg, #9b59b6, #d8b5e6);
        padding: 20px;
    }

    .similar-services-header h3 {
        color: white;
        margin: 0;
        font-size: 1.3em;
        text-align: center;
    }

    .similar-services-body {
        padding: 20px;
    }

    .similar-item {
        padding: 15px 0;
    }

    .similar-name {
        margin: 0 0 8px;
        font-size: 1.1em;
    }

    .similar-name a {
        color: #8e44ad;
        text-decoration: none;
        transition: color 0.3s ease;
    }

    .similar-name a:hover {
        color: #9b59b6;
    }

    .similar-meta {
        display: flex;
        gap: 15px;
        color: #666;
        font-size: 0.9em;
    }

    .meta-duration,
    .meta-price {
        display: flex;
        align-items: center;
        gap: 3px;
    }

    .similar-divider {
        height: 1px;
        background: linear-gradient(90deg, transparent, #f0e5f5, transparent);
        margin: 5px 0;
    }

    /* Пустое состояние */
    .empty-state {
        text-align: center;
        padding: 40px;
    }

    .empty-icon {
        font-size: 3em;
        margin-bottom: 15px;
        opacity: 0.5;
    }

    .empty-state p {
        color: #666;
        font-size: 1.1em;
    }

    /* Анимации */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .master-card-wrapper:nth-child(1) { animation-delay: 0.1s; }
    .master-card-wrapper:nth-child(2) { animation-delay: 0.15s; }
    .master-card-wrapper:nth-child(3) { animation-delay: 0.2s; }
    .master-card-wrapper:nth-child(4) { animation-delay: 0.25s; }
    .master-card-wrapper:nth-child(5) { animation-delay: 0.3s; }
    .master-card-wrapper:nth-child(6) { animation-delay: 0.35s; }

    /* Адаптивность */
    @media (max-width: 992px) {
        .service-stats {
            grid-template-columns: 1fr;
        }

        .masters-grid {
            grid-template-columns: 1fr;
        }
    }

    @media (max-width: 768px) {
        .service-header h1 {
            font-size: 2.2em;
        }

        .service-main-header {
            flex-direction: column;
            text-align: center;
        }

        .master-actions {
            flex-direction: column;
        }
    }

    @media (max-width: 480px) {
        .service-header h1 {
            font-size: 1.8em;
        }

        .service-main-body {
            padding: 20px;
        }
    }
CSS;

$this->registerCss($css);
?>