<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Отчет по выручке';
$this->params['breadcrumbs'][] = ['label' => 'Отчеты', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="reports-revenue">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="panel panel-default">
        <div class="panel-body">
            <?php $form = ActiveForm::begin(['method' => 'get', 'action' => ['revenue']]); ?>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>От</label>
                        <input type="date" name="from_date" class="form-control" value="<?= $fromDate ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>До</label>
                        <input type="date" name="to_date" class="form-control" value="<?= $toDate ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <button type="submit" class="btn btn-primary form-control">Применить</button>
                    </div>
                </div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-success">
                <div class="panel-heading">
                    <h3 class="panel-title">Общая выручка за период</h3>
                </div>
                <div class="panel-body text-center">
                    <p style="font-size: 48px; color: green;"><?= number_format($totalRevenue, 2, '.', ' ') ?> руб.</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Выручка по дням</h3>
                </div>
                <div class="panel-body">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th>Дата</th>
                            <th>Кол-во</th>
                            <th>Выручка</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($dailyRevenue as $day): ?>
                            <tr>
                                <td><?= Yii::$app->formatter->asDate($day['date'], 'php:d.m.Y') ?></td>
                                <td><?= $day['count'] ?></td>
                                <td><strong><?= number_format($day['revenue'], 2, '.', ' ') ?> руб.</strong></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                        <tr class="info">
                            <th><strong>Итого:</strong></th>
                            <th><?= array_sum(array_column($dailyRevenue, 'count')) ?></th>
                            <th><strong><?= number_format($totalRevenue, 2, '.', ' ') ?> руб.</strong></th>
                        </tr>
                        </tfoot>
                    </table>

                    <?php if (empty($dailyRevenue)): ?>
                        <p class="text-muted">Нет данных за выбранный период</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Выручка по услугам</h3>
                </div>
                <div class="panel-body">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th>Услуга</th>
                            <th>Кол-во</th>
                            <th>Выручка</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($serviceRevenue as $service): ?>
                            <tr>
                                <td>
                                    <?= Html::encode($service['service_name']) ?>
                                    <br><small class="text-muted">Категория: <?= $service['category_id'] ?></small>
                                </td>
                                <td><?= $service['count'] ?></td>
                                <td><strong><?= number_format($service['revenue'], 2, '.', ' ') ?> руб.</strong></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>

                    <?php if (empty($serviceRevenue)): ?>
                        <p class="text-muted">Нет данных за выбранный период</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="text-center">
        <?= Html::a('Назад к отчетам', ['index'], ['class' => 'btn btn-default']) ?>
    </div>
</div>