<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Управление услугами: ' . $master->surname . ' ' . $master->name;
$this->params['breadcrumbs'][] = ['label' => 'Привязка услуг', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="master-service-manage">
        <h1><?= Html::encode($this->title) ?></h1>

        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div class="alert alert-success">
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        <?php endif; ?>

        <div class="panel panel-default">
            <div class="panel-body">

                <?php $form = ActiveForm::begin(); ?>

                <table class="table table-striped table-bordered">
                    <thead>
                    <tr>
                        <th width="50">Выбрать</th>
                        <th>Услуга</th>
                        <th>Категория</th>
                        <th>Базовая цена</th>
                        <th>Длительность</th>
                        <th>Наценка/скидка</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($allServices as $service): ?>
                        <?php
                        $checked = isset($masterServices[$service->id]);
                        $modifier = $checked ? $masterServices[$service->id]->price_modifier : 0;
                        ?>
                        <tr>
                            <td class="text-center">
                                <input type="checkbox"
                                       name="services[<?= $service->id ?>][selected]"
                                       value="1"
                                    <?= $checked ? 'checked' : '' ?>
                                       class="service-checkbox"
                                       data-id="<?= $service->id ?>">
                            </td>
                            <td>
                                <strong><?= Html::encode($service->name) ?></strong>
                                <?php if ($service->description): ?>
                                    <br><small><?= Html::encode($service->description) ?></small>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?= $service->category ? $service->category->name : '—' ?>
                            </td>
                            <td><?= $service->price ?> руб.</td>
                            <td><?= $service->duration ?> мин.</td>
                            <td>
                                <input type="number"
                                       name="services[<?= $service->id ?>][price_modifier]"
                                       value="<?= $modifier ?>"
                                       step="0.01"
                                       class="form-control price-modifier"
                                       data-id="<?= $service->id ?>"
                                       style="width: 100px;"
                                    <?= !$checked ? 'disabled' : '' ?>>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>

                <div class="form-group">
                    <?= Html::submitButton('Сохранить', ['class' => 'btn btn-success']) ?>
                    <?= Html::a('Назад', ['index'], ['class' => 'btn btn-default']) ?>
                </div>

                <?php ActiveForm::end(); ?>

            </div>
        </div>
    </div>

<?php
$script = <<< JS
    $('.service-checkbox').on('change', function() {
        var id = $(this).data('id');
        var modifier = $('.price-modifier[data-id="' + id + '"]');
        modifier.prop('disabled', !$(this).is(':checked'));
    });
JS;
$this->registerJs($script);
?>