<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Привязка услуг к мастерам';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="master-service-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Выберите мастера для настройки услуг</h3>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <?php foreach ($masters as $master): ?>
                            <div class="col-md-4 col-sm-6">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h4><?= Html::encode($master->surname . ' ' . $master->name) ?></h4>
                                    </div>
                                    <div class="panel-body">
                                        <p><strong>Телефон:</strong> <?= Html::encode($master->phone_number) ?></p>
                                        <?php
                                        $masterInfo = \app\models\MasterInfo::find()->where(['user_id' => $master->id])->one();
                                        $servicesCount = $masterInfo ? \app\models\MasterService::find()->where(['master_info_id' => $masterInfo->id])->count() : 0;
                                        ?>
                                        <p><strong>Услуг привязано:</strong> <?= $servicesCount ?></p>
                                        <?= Html::a('Управлять услугами', ['manage', 'id' => $master->id], [
                                            'class' => 'btn btn-primary btn-block'
                                        ]) ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <hr>

                    <div class="text-center">
                        <?= Html::a('Привязка', ['batch'], [
                            'class' => 'btn btn-warning btn-lg'
                        ]) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>