<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Привязка услуг к мастерам';
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="master-service-batch">
        <h1><?= Html::encode($this->title) ?></h1>

        <div class="alert alert-info">
            <i class="glyphicon glyphicon-info-sign"></i>
            Отметьте услуги для каждого мастера. Можно выбрать несколько услуг одновременно.
            <br>Для навигации по таблице используйте горизонтальную прокрутку.
        </div>

        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div class="alert alert-success">
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        <?php endif; ?>

        <div class="panel panel-default">
            <div class="panel-body">

                <?php $form = ActiveForm::begin(); ?>

                <!-- Контейнер с горизонтальной прокруткой -->
                <div style="overflow-x: auto; width: 100%;">
                    <table class="table table-bordered table-striped" style="min-width: 1200px;">
                        <thead>
                        <tr>
                            <th style="width: 200px; position: sticky; left: 0; background: #f5f5f5; z-index: 10;">Мастер</th>
                            <?php foreach ($services as $service): ?>
                                <th class="text-center" style="min-width: 120px;">
                                    <?= Html::encode(mb_substr($service->name, 0, 15)) ?>
                                    <?php if (mb_strlen($service->name) > 15): ?>...<?php endif; ?>
                                    <br><small><?= $service->duration ?> мин.</small>
                                </th>
                            <?php endforeach; ?>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($masters as $master): ?>
                            <?php
                            $masterInfo = \app\models\MasterInfo::find()->where(['user_id' => $master->id])->one();
                            $masterServices = $masterInfo ? \app\models\MasterService::find()
                                ->where(['master_info_id' => $masterInfo->id])
                                ->indexBy('service_id')
                                ->all() : [];
                            ?>
                            <tr>
                                <td style="position: sticky; left: 0; background: white; z-index: 5;">
                                    <strong><?= Html::encode($master->surname . ' ' . $master->name) ?></strong>
                                    <br><small><?= Html::encode($master->phone_number) ?></small>
                                </td>
                                <?php foreach ($services as $service): ?>
                                    <?php $checked = isset($masterServices[$service->id]); ?>
                                    <td class="text-center">
                                        <input type="checkbox"
                                               name="batch[<?= $master->id ?>][<?= $service->id ?>]"
                                               value="1"
                                            <?= $checked ? 'checked' : '' ?>
                                               class="service-checkbox"
                                               data-master="<?= $master->id ?>"
                                               data-service="<?= $service->id ?>"
                                               title="<?= Html::encode($service->name) ?>">
                                    </td>
                                <?php endforeach; ?>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <div class="row" style="margin: 15px 0;">
                    <div class="col-md-12">
                        <button type="button" class="btn btn-info" id="select-all">
                            <i class="glyphicon glyphicon-check"></i> Выбрать всех
                        </button>
                        <button type="button" class="btn btn-default" id="deselect-all">
                            <i class="glyphicon glyphicon-unchecked"></i> Снять всех
                        </button>

                        <button type="button" class="btn btn-warning" id="select-master-1">
                            Выбрать для Волкова
                        </button>
                        <button type="button" class="btn btn-warning" id="select-master-2">
                            Выбрать для Семенова
                        </button>
                        <button type="button" class="btn btn-warning" id="select-master-3">
                            Выбрать для Сенькиной
                        </button>
                    </div>
                </div>

                <div class="form-group">
                    <?= Html::submitButton('<i class="glyphicon glyphicon-save"></i> Сохранить все', [
                        'class' => 'btn btn-success btn-lg'
                    ]) ?>
                    <?= Html::a('Назад', ['index'], ['class' => 'btn btn-default']) ?>
                </div>

                <?php ActiveForm::end(); ?>

            </div>
        </div>
    </div>

<?php
$script = <<< JS
    // Выбрать всех
    $('#select-all').on('click', function() {
        $('.service-checkbox').prop('checked', true);
    });
    
    // Снять всех
    $('#deselect-all').on('click', function() {
        $('.service-checkbox').prop('checked', false);
    });
    
    // Выбрать для конкретного мастера (по индексу)
    $('#select-master-1').on('click', function() {
        $('.service-checkbox[data-master="4"]').prop('checked', true); // ID Волкова
    });
    
    $('#select-master-2').on('click', function() {
        $('.service-checkbox[data-master="9"]').prop('checked', true); // ID Семенова
    });
    
    $('#select-master-3').on('click', function() {
        $('.service-checkbox[data-master="10"]').prop('checked', true); // ID Сенькиной
    });
JS;
$this->registerJs($script);
?>