<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "master_schedule".
 *
 * @property int $id
 * @property int $master_info_id
 * @property int|null $day_of_week 1-пн, 2-вт, 3-ср, 4-чт, 5-пт, 6-сб, 7-вс
 * @property string|null $start_time
 * @property string|null $end_time
 * @property int|null $is_working
 *
 * @property MasterInfo $masterInfo
 */
class MasterSchedule extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'master_schedule';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['day_of_week', 'start_time', 'end_time'], 'default', 'value' => null],
            [['is_working'], 'default', 'value' => 1],
            [['master_info_id'], 'required'],
            [['master_info_id', 'day_of_week', 'is_working'], 'integer'],
            [['start_time', 'end_time'], 'safe'],
            [['master_info_id', 'day_of_week'], 'unique', 'targetAttribute' => ['master_info_id', 'day_of_week']],
            [['master_info_id'], 'exist', 'skipOnError' => true, 'targetClass' => MasterInfo::class, 'targetAttribute' => ['master_info_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'master_info_id' => 'Master Info ID',
            'day_of_week' => 'Day Of Week',
            'start_time' => 'Start Time',
            'end_time' => 'End Time',
            'is_working' => 'Is Working',
        ];
    }

    /**
     * Gets query for [[MasterInfo]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMasterInfo()
    {
        return $this->hasOne(MasterInfo::class, ['id' => 'master_info_id']);
    }

}
