<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "master_info".
 *
 * @property int $id
 * @property int $user_id
 * @property string|null $specialization
 * @property string|null $certificate_expiry
 * @property string|null $certificate_photo
 * @property string|null $bio
 * @property int|null $experience_years
 * @property int|null $is_active
 *
 * @property Appointment[] $appointments
 * @property MasterPortfolio[] $masterPortfolios
 * @property MasterSchedule[] $masterSchedules
 * @property MasterService[] $masterServices
 * @property Service[] $services
 * @property User $user
 */
class MasterInfo extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'master_info';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['specialization', 'certificate_expiry', 'certificate_photo', 'bio', 'experience_years'], 'default', 'value' => null],
            [['is_active'], 'default', 'value' => 1],
            [['user_id'], 'required'],
            [['user_id', 'experience_years', 'is_active'], 'integer'],
            [['specialization', 'bio'], 'string'],
            [['certificate_expiry'], 'safe'],
            [['certificate_photo'], 'string', 'max' => 500],
            [['user_id'], 'unique'],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['user_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'ID пользователя',
            'specialization' => 'Специализация',
            'certificate_expiry' => 'Срок действия сертификата',
            'certificate_photo' => 'Фото сертификата',
            'bio' => 'О себе',
            'experience_years' => 'Опыт работы (лет)',
            'is_active' => 'Активен',
        ];
    }

    /**
     * Gets query for [[Appointment]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getAppointments()
    {
        return $this->hasMany(Appointment::class, ['master_info_id' => 'id']);
    }

    /**
     * Gets query for [[MasterPortfolios]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMasterPortfolios()
    {
        return $this->hasMany(MasterPortfolio::class, ['master_info_id' => 'id']);
    }

    /**
     * Gets query for [[MasterSchedules]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMasterSchedules()
    {
        return $this->hasMany(MasterSchedule::class, ['master_info_id' => 'id']);
    }

    /**
     * Gets query for [[MasterService]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMasterServices()
    {
        return $this->hasMany(MasterService::class, ['master_info_id' => 'id']);
    }

    /**
     * Gets query for [[Service]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getServices()
    {
        return $this->hasMany(Service::class, ['id' => 'service_id'])->viaTable('master_services', ['master_info_id' => 'id']);
    }

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

}
