<?php

namespace app\models;

use Yii;

class Appointment extends \yii\db\ActiveRecord
{
    const PAYMENT_METHOD_CASH = 'cash';
    const PAYMENT_METHOD_CARD = 'card';
    const PAYMENT_METHOD_ONLINE = 'online';

    const STATUS_PENDING = 'pending';
    const STATUS_CONFIRMED = 'confirmed';
    const STATUS_COMPLETED = 'completed';
    const STATUS_CANCELLED = 'cancelled';

    public static function tableName()
    {
        return 'appointments';
    }

    public function rules()
    {
        return [
            [['additional_info'], 'default', 'value' => null],
            [['payment_method'], 'default', 'value' => 'cash'],
            [['status'], 'default', 'value' => 'pending'],
            [['master_info_id', 'service_id', 'client_id', 'start_time', 'end_time', 'payment_method'], 'required'],
            [['master_info_id', 'service_id', 'client_id', 'status'], 'integer'],
            [['start_time', 'end_time', 'created_at'], 'safe'],
            [['payment_method'], 'string', 'max' => 50],
            [['additional_info'], 'string'],
            ['payment_method', 'in', 'range' => array_keys(self::optsPaymentMethod())],
            [['client_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['client_id' => 'id']],
            [['master_info_id'], 'exist', 'skipOnError' => true, 'targetClass' => MasterInfo::class, 'targetAttribute' => ['master_info_id' => 'id']],
            [['service_id'], 'exist', 'skipOnError' => true, 'targetClass' => Service::class, 'targetAttribute' => ['service_id' => 'id']],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'client_id' => 'Клиент',
            'master_info_id' => 'Мастер',
            'service_id' => 'Услуга',
            'start_time' => 'Начало',
            'end_time' => 'Окончание',
            'payment_method' => 'Способ оплаты',
            'additional_info' => 'Доп. информация',
            'status' => 'Статус',
            'created_at' => 'Дата создания',
        ];
    }

    public function getClient()
    {
        return $this->hasOne(User::class, ['id' => 'client_id']);
    }

    public function getMasterInfo()
    {
        return $this->hasOne(MasterInfo::class, ['id' => 'master_info_id']);
    }

    public function getService()
    {
        return $this->hasOne(Service::class, ['id' => 'service_id']);
    }

    public static function optsPaymentMethod()
    {
        return [
            self::PAYMENT_METHOD_CASH => 'Наличные',
            self::PAYMENT_METHOD_CARD => 'Карта',
            self::PAYMENT_METHOD_ONLINE => 'Онлайн',
        ];
    }

    public function displayPaymentMethod()
    {
        return self::optsPaymentMethod()[$this->payment_method];
    }
}