<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%service_categories}}`.
 */
class m260223_070019_create_service_categories_table extends Migration
{
    public function safeUp()
    {
        $this->createTable('service_categories', [
            'id' => $this->primaryKey(),
            'name' => $this->string(255)->notNull(),
            'description' => $this->text(),
            'sort' => $this->integer()->defaultValue(0),
        ]);

        // Добавляем поле category_id в таблицу services
        $this->addColumn('services', 'category_id', $this->integer());
        $this->addColumn('services', 'is_active', $this->tinyInteger()->defaultValue(1));

        $this->addForeignKey(
            'fk-services-category_id',
            'services',
            'category_id',
            'service_categories',
            'id',
            'SET NULL'
        );

        // Добавляем тестовые категории
        $this->batchInsert('service_categories', ['name', 'description', 'sort'], [
            ['Парикмахерские услуги', 'Стрижки, укладки, окрашивание', 1],
            ['Ногтевой сервис', 'Маникюр, педикюр, наращивание', 2],
            ['Косметология', 'Чистка лица, уход за кожей', 3],
            ['Макияж', 'Дневной, вечерний, свадебный', 4],
            ['Массаж', 'Лечебный, расслабляющий', 5],
        ]);
    }

    public function safeDown()
    {
        $this->dropForeignKey('fk-services-category_id', 'services');
        $this->dropColumn('services', 'category_id');
        $this->dropColumn('services', 'is_active');
        $this->dropTable('service_categories');
    }
}
